require( "scripts/chocshopstyle.lua" );

MakeDialog
{
	name = "ok",
	
	VTintWindow
	{
	    x		= 0, 
	    y		= 0, 
	    w		= 800, 
	    h		= 600,
	    color	= Color( 0, 0, 0, 200 ),
	    time	= 200,
	    fade	= true
	},
	
	RBounceWindow
	{
		x			= 200,
		y			= -600 - 300,
	    targetposx	= 200, 
	    targetposy	= 150,
	    bouncelen	= 200, 
	    bouncefunc	= "sincx",
	    w			= 400,
	    h			= 300,
	    
		KSplit9Image
		{ 
			image	= "ui/backgrounds/split9_dialog_small",	
			x		= kCenter,
			y		= kCenter,
			w		= 400,
			h		= 300,
			x1		= 40,
			y1		= 40,
			x2		= 40,
			y2		= 40,
			
			---------------------------------------------- Title
			RShrinkText
			{
				x		= 12, 
				y		= 8,
				w		= kMax - 16,
				h		= 40,
				font	= Dialog_TitleFont,
				name	= "ok_title",
				flags	= kVAlignCenter + kHAlignCenter,
				label	= gDialogTable.title
			},
			
			---------------------------------------------- Body
			RShrinkText
			{
				x		= 16,
				y		= 46,
				w		= kMax-24,
				h		= kMax-70,
				font	= Dialog_BodyFont,
				name	= "ok_body",
				flags	= kVAlignCenter + kHAlignCenter,
				label	= gDialogTable.body
			},
	        
			---------------------------------------------- Ok
			SetStyle(CSOvalGreenButtonStyle),
			Button
			{
				x			= kCenter,
				y			= 220,		
				name		= "entername_ok_button",
				label		= "app_ok",
				type		= kPush,
				default		= true,
				command		= 
					function()
						PostMessage( CreateNamedMessage( kTintOff ) );
						DoTransition( kBounceBack );
						CloseWindow();
					end
			},
		},
	},
}
